<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package;
use App\Models\Therapist;
use App\Models\Slot;
use App\Models\UserReview;
use App\Models\Coupons;
use App\Models\Prescription;
use App\Models\ConsulationNote;
use App\Models\WorkingHours;
use App\Models\SlotShedule;
use App\Models\PaymentDetails;
use App\Models\Appointments;
use App\Models\ServiceFeeStructure;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Database\QueryException;
use App\Models\UserWalletTransactions;
use App\Models\UserWallet;
use App\Models\TypesOfWallet;
use App\Models\WalletPoint;
use Illuminate\Support\Facades\DB;
use App\Notifications\AppoinmentNotification;
use App\Models\Admin;
use Illuminate\Support\Facades\Notification;
use App\Models\PushNotification;
use Mgcodeur\CurrencyConverter\Facades\CurrencyConverter;

class BookingController extends Controller
{

    public function getPackages(Request $request)
    {
        $data = [];
        $data['service_id'] = $request->service_id;
        $data['therapist'] = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('id', $request->therapist_id)->first();
        $data['therapist']->image = asset('assets/uploads/therapist/') . '/' . $data['therapist']->image;


        $array = Package::select('id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'description', 'image')->where('service_id', $request->service_id)->where('status', 'ACTIVE')->get();
        $pc = $request->provider_category_id;
        foreach ($array as $key => $item) {

            $data['packages'][$key]['id'] = $item->id;
            $data['packages'][$key]['service_fee_id'] = $item->service_fee_id;
            $data['packages'][$key]['title'] = $item->title;
            $data['packages'][$key]['no_of_sessions'] = $item->no_of_sessions;
            $data['packages'][$key]['discount'] = $item->discount;

            $data['packages'][$key]['description'] = Str::limit((strip_tags($item->description)), 50, '...');
            $data['packages'][$key]['description'] = preg_replace("/&nbsp;/", '', $item->description);
            $data['packages'][$key]['description'] = preg_replace("/\s+/", " ", $item->description);
            $data['packages'][$key]['image'] = asset('assets/uploads/package/') . '/' . $item->image;

            if ($item->service_fee_id != '' || $item->service_fee_id != NULL) {
                $sfs = ServiceFeeStructure::whereIn('id', json_decode($item->service_fee_id))
                    ->where('provider_category_id', $pc)
                    ->where('service_id', $request->service_id)
                    ->with('callMethod')
                    ->get();


                if (count($sfs) == 0) {
                    continue;
                }

                $discount = $item->discount;
                $data['packages'][$key]['communication_methods'] = collect($sfs->toArray())->map(function ($item2) use ($discount) {
                    $convertedAmount = round(CurrencyConverter::convert($item2['rate'])
                        ->from('INR')
                        ->to(auth()->user()->currency_code)
                        ->get(), 2);

                    $item['call_method_id'] = $item2['call_method_id'];
                    $item['call_method'] = $item2['call_method']['name'];
                    $item['actual_fee'] = $convertedAmount;
                    $subtotal = $convertedAmount * ($discount / 100);
                    $item['discount_fee'] = round($convertedAmount -  $subtotal, 2);
                    $item['currency'] = auth()->user()->currency_symbol;
                    return $item;
                });
            } else {
                $data['packages'][$key]['communication_methods'] = [];
            }
        }

        // $array['packages'] = collect($array['packages']->toArray())->map(function ($item) use ($pc) {

        //     $sfs = ServiceFeeStructure::whereIn('id', json_decode($item['service_fee_id']))->with('callMethod')->where('provider_category_id', $pc)->get();
        //     if (count($sfs) == 0) {
        //         return true;
        //     }
        //     $discount = $item['discount'];
        //     $item['communication_methods'] = collect($sfs->toArray())->map(function ($item2) use ($discount) {
        //         $item['call_method_id'] = $item2['call_method_id'];
        //         $item['call_method'] = $item2['call_method']['name'];
        //         $item['actual_fee'] = $item2['rate'];
        //         $subtotal = $item2['rate'] * ($discount / 100);
        //         $item['discount_fee'] = $item2['rate'] -  $subtotal;
        //         return $item;
        //     });

        //     $item['image'] = asset('assets/uploads/package/') . '/' . $item['image'];
        //     $item['description'] = Str::limit((strip_tags($item['description'])), 50, '...');
        //     $item['description'] = preg_replace("/&nbsp;/", '', $item['description']);
        //     $item['description'] = preg_replace("/\s+/", " ", $item['description']);
        //     return $item;
        // });

        // $data['packages'] = $array;
        $sfs = ServiceFeeStructure::where('service_id', $request->service_id)->where('provider_category_id', $request->provider_category_id)->get();

        foreach ($sfs as $key => $item) {
            $convertedAmount = round(CurrencyConverter::convert($item->rate)
                ->from('INR')
                ->to(auth()->user()->currency_code)
                ->get(), 2);
            $call_methods[$key] = [
                'id' => $item->callMethod->id,
                'name' => $item->callMethod->name,
                'fee' => $convertedAmount,
                'currency' => auth()->user()->currency_symbol
            ];
        }

        $data['fee_structure'] = $call_methods;

        $item = collect($call_methods)->unique()->values();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function searchSlot(Request $request)
    {

        $current_date = date("Y-m-d");
        $current_time = date("H:i");
        $html = '';
        $data = [];
        $booking_date = date("Y-m-d", strtotime($request->bookingDate));
        $error = 'No slots Found';
        $day = Carbon::createFromFormat('Y-m-d', $request->bookingDate)->format('l');
        $service = $request->service;

        $slot = Slot::where('therapist_id', $request->therapist)->first();

        if ($slot) {
            $workinghours = WorkingHours::where('slot_id', $slot->id)
                ->where('day', $day)
                // ->where('service_id', $service)
                ->first();


            if ($workinghours) {

                $slotlist = SlotShedule::where('slot_id', $workinghours->id)->where('call_method_id', $request->callmethod)->first();

                if ($slotlist) {
                    $i = 0;
                    $j = 0;
                    foreach (json_decode($slotlist->slots) as $key => $x) {
                        //***** */
                        $slot_flag = 0;
                        $bookedslots = Appointments::where('therapist_id', $request->therapist)->where('Appointment_Date', $booking_date)->get();
                        if ($bookedslots) {
                            foreach ($bookedslots as $bookedslot) {
                                $booked_slotlist = SlotShedule::where('id', $bookedslot->slot_id)->first();
                                $flag = 0;
                                $next_booked_slot = '';
                                $prev_slot = '';
                                $prev = '';

                                foreach (json_decode($booked_slotlist->slots) as $k => $bs) {
                                    if ($bookedslot->Appointment_Time == $bs) {

                                        $flag = 1;
                                        continue;
                                    } else {
                                        if ($flag == 1) {
                                            $prev = $prev_slot;
                                            $next_booked_slot = $bs;
                                            break;
                                        }
                                    }
                                    $prev_slot = $bs;
                                }
                                $prev = $prev_slot;

                                $time1  = date("H:i", strtotime($bookedslot->Appointment_Time));
                                //  $time2 = date("H:i", strtotime($next_booked_slot));
                                $time2 = date("H:i", strtotime($bookedslot->end_time));
                                //    $time3 = date("H:i", strtotime($prev));
                                $checkedtime = date("H:i", strtotime($x));
                                if ($checkedtime >= $time1 && $checkedtime < $time2) {
                                    //  if (($checkedtime >= $time1 && $checkedtime < $time2) || ($checkedtime > $time3 && $checkedtime <= $time1)) {
                                    $slot_flag = 1;
                                    break;
                                }
                            }
                        }
                        if ($slot_flag == 1) {

                            continue;
                        }
                        //*** */
                        $givenDateTime = date("H:i", strtotime($x));


                        if ($current_date == $request->bookingDate) {

                            if ($current_time < $givenDateTime) {

                                $data[$i]['slot_id'] = $slotlist->id;
                                $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                                $data[$i]['slots'] = $x;
                                if ($booked) {
                                    $data[$i]['slot_status'] = $booked->Appointment_Status;
                                } else {
                                    $data[$i]['slot_status'] = 'Available';
                                }
                                $i++;
                            }
                        } else {

                            $data[$j]['slot_id'] = $slotlist->id;
                            $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();
                            $data[$j]['slots'] = $x;
                            if ($booked) {
                                $data[$j]['slot_status'] = $booked->Appointment_Status;
                            } else {
                                $data[$j]['slot_status'] = 'Available';
                            }
                            $j++;
                        }
                    }

                    return response()->json(
                        array(
                            'status' => True,
                            'data' => $data
                        ),
                        200
                    );
                } else {

                    return response()->json(
                        array(
                            'status' => False,
                            'data' => $error
                        ),
                        200
                    );
                }
            } else {
                return response()->json(
                    array(
                        'status' => False,
                        'data' => $error
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $error
                ),
                200
            );
        }

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function packageBooking(Request $request)
    {
        $data = [];
        $call_methods = [];
        $grandtotal = 0;
        $array = Package::select('id', 'service_id', 'service_fee_id', 'title', 'no_of_sessions', 'discount', 'description', 'image')->where('id', $request->package_id)->first();
        $data = $array;
        $service_ids = json_decode($array->service_fee_id);
        $sfs = ServiceFeeStructure::whereIn('id', $service_ids)->where('provider_category_id', $request->provider_category)->first();



        if ($sfs) {
            $total = $sfs->rate * $array->no_of_sessions;
            $subtotal = $total * ($array->discount / 100);
            $grandtotal = $total - $subtotal;
            $data['communication_method_id'] = $sfs->callMethod->id;
            $data['communication_method'] = $sfs->callMethod->name;
            $data['actual_price'] = $sfs->rate;
            $data['discount_price'] = $grandtotal;
        }

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function getCoupons(Request $request)
    {
        $date = date('Y-m-d', strtotime(Carbon::now()));
        // $data = Coupons::select('id', 'promo_code', 'discount_type', 'discount_rate')->where('start_date', '<=', $date)->Where('expiry_date', '>=', $date)->first();
        $data = DB::select("SELECT id, promo_code,discount_type, discount_rate,start_date,expiry_date FROM `coupons` WHERE `start_date` <= '2024-01-25' AND `expiry_date` >= '2024-01-25'");
        // print_r($data);
        // die();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }


    public function addCoupons(Request $request)
    {
        $total = 0;
        $data = Coupons::where('id', $request->coupon_code)->first();

        if ($data->discount_type == '%') {
            $total = $request->total * ($data->discount_rate / 100);
            $total = $request->total - $total;
        } else {
            $total = $request->total - $request->coupon_code;
        }
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $total
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function bookAppoinment(Request $request)
    {

        $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();
        if ($userwallet->balance < $request->fee) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Your wallet account does not have sufficient balance."
                ),
                200
            );
        }

        $booking_date = date("Y-m-d", strtotime($request->booking_date));
        $dob = date("Y-m-d", strtotime($request->dob));
        $exist = Appointments::where('Appointment_Date', $booking_date)->where('slot_id', $request->slot_id)->where('Appointment_Time', $request->slot)->first();
        if ($exist != null) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Your already Booked this slot"
                ),
                200
            );
        }
        try {
            if ($request->package_id) {
                $packageid = $request->package_id;
            } else {
                $packageid = null;
            }

            $duration = Slot::where('therapist_id', $request->therapist)->pluck('call_duration')->first();
            $givenDateTime = date("H:i", strtotime($request->slot));

            $time = $booking_date . " " . $givenDateTime . ":00";
            $closeTime =  Carbon::parse($time)->addMinutes($duration);
            if ($request->follow_up == 1) {

                $followupdate = Appointments::where('user_id', auth()->user()->id)
                    ->where('follow_up_date', $request->booking_date)
                    ->pluck('id')->first();

                if ($followupdate) {
                    $res = Appointments::where('id', $followupdate)->update(['follow_up_date' => NULL]);
                }
            }

            $appointment = new Appointments();
            $appointment->Appointment_Type = $request->call_type;
            $appointment->Appointment_Date = $booking_date;
            $appointment->Appointment_Time = $request->slot;
            $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
            $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
            $appointment->therapist_id = $request->therapist;
            $appointment->service_id = $request->service;
            $appointment->slot_id = $request->slot_id;
            $appointment->user_id = auth()->user()->id;
            $appointment->package_id = $packageid;
            $appointment->fee = $request->fee;
            $appointment->end_time = date('h:i A', strtotime($closeTime));
            $appointment->payment_id = PaymentDetails::where('user_id', auth()->user()->id)->orderBy('id', 'DESC')->pluck('id')->first();
            $appointment->save();

            Appointments::where('id', $appointment->id)
                ->update(['session_id' => '1_MX40NzQ4MjgzMX5-MTcxND' . md5($appointment->id) . '-fn4']);

            $point = WalletPoint::orderBy('id', 'DESC')->first();

            $userpoint = $point->point * $request->fee;

            $userBalance = $userwallet->balance;
            $balance = $userBalance - $userpoint;

            $userWalletTransaction = new UserWalletTransactions();
            $userWalletTransaction->user_id = auth()->user()->id;
            $userWalletTransaction->wallet_id = 1;
            $userWalletTransaction->type = 'Debit';
            $userWalletTransaction->amount = $request->fee;
            $userWalletTransaction->point = $userpoint;
            $userWalletTransaction->current_balance = $balance;
            $userWalletTransaction->save();

            $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                'user_id' => auth()->user()->id,
                'balance' => $balance
            ]);

            if ($appointment) {
                $data = [
                    'appoinment_id' => $appointment->id
                ];
                $notification = Admin::first();

                #store notification info into notifications table
                $notification->notify(new AppoinmentNotification($data));


                //** push notification */
                PushNotification::create([
                    'title' => 'Booking Alert',
                    'message' => 'Hi, ' . auth()->user()->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with Yellowcloud. Thank you for visting us ',
                    'therapist_notification' => 'You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with ' . auth()->user()->First_Name . '. ',
                    'type' => 'Appointment',
                    'user_id' => auth()->user()->id,
                    'therapist_id' => $request->therapist,
                    'appoinment_id' =>  $appointment->id
                ]);
                $data = [
                    "to" => auth()->user()->device_token,
                    "notification" => [
                        'title' => 'Yellowcloud Appointment',
                        'body' => 'Hi, ' . auth()->user()->First_Name . '! You have an upcoming appointment on ' . $request->booking_date . ' at ' . $request->slot . ' with Yellowcloud. Thank you for visting us ',
                        //      'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". "
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];
                $dataString = json_encode($data);
                $SERVER_API_KEY = env('FCM_SERVER_KEY');
                $headers = [
                    'Authorization: key=' . $SERVER_API_KEY,
                    'Content-Type: application/json',
                ];

                $ch = curl_init();

                curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
                // Disabling SSL Certificate support temporarly
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
                // Execute post
                $result = curl_exec($ch);

                // Close connection
                curl_close($ch);

                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment is Booked Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function previousAppoinments(Request $request)
    {
        try {

            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Join')
                ->where('Appointment_Status', '!=', 'No Participants')
                ->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                //    $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                //     $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //    $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time < $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                            ->from('INR')
                            ->to(auth()->user()->currency_code)
                            ->get(), 2);
                        $data[$key]['currency'] = auth()->user()->currency_symbol;;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                        ->from('INR')
                        ->to(auth()->user()->currency_code)
                        ->get(), 2);
                    $data[$key]['currency'] = auth()->user()->currency_symbol;;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function upcomingAppoinments(Request $request)
    {

        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Date', '>=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                //   $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                //   $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //   $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {

                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                                ->from('INR')
                                ->to(auth()->user()->currency_code)
                                ->get(), 2);
                            $data[$key]['currency'] = auth()->user()->currency_symbol;;
                            $key++;
                        } else {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                                ->from('INR')
                                ->to(auth()->user()->currency_code)
                                ->get(), 2);
                            $data[$key]['currency'] = auth()->user()->currency_symbol;;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                            ->from('INR')
                            ->to(auth()->user()->currency_code)
                            ->get(), 2);
                        $data[$key]['currency'] = auth()->user()->currency_symbol;;

                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                        ->from('INR')
                        ->to(auth()->user()->currency_code)
                        ->get(), 2);
                    $data[$key]['currency'] = auth()->user()->currency_symbol;;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function upcomingAppoinmentsHomePage(Request $request)
    {
        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)
                ->where('Appointment_Status', '!=', 'Cancel')
                ->where('Appointment_Status', '!=', 'Missed')
                ->where('Appointment_Status', '!=', 'Completed')
                ->where('Appointment_Date', '>=', date('Y-m-d'))
                ->orderBy('Appointment_Date', 'DESC')
                ->orderByRaw("STR_TO_DATE(Appointment_Time, '%h:%i %p') DESC")
                ->get();
            foreach ($array as $item) {
                if ($key == 2) {
                    break;
                }
                // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                //  $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        if ($item->Appointment_Status == 'Join' || $item->Appointment_Status == 'No Participants') {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                                ->from('INR')
                                ->to(auth()->user()->currency_code)
                                ->get(), 2);
                            $data[$key]['currency'] = auth()->user()->currency_symbol;;
                            $key++;
                        } else {

                            $data[$key]['id'] = $item->id;
                            $data[$key]['therapist_id'] = $item->therapist->id;
                            $data[$key]['therapist_name'] = $item->therapist->full_name;
                            $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                            $data[$key]['therapist_designation'] = $item->therapist->designation;
                            $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                            $data[$key]['start_time'] = $item->Appointment_Time;
                            $data[$key]['end_time'] =  $item->end_time;
                            $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                            $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                            $data[$key]['call_type_id'] = $item->callMethod->id;
                            $data[$key]['call_type'] = $item->callMethod->name;
                            $data[$key]['service'] = $item->service_id;
                            $data[$key]['follow_up_date'] = $item->follow_up_date;
                            $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                                ->from('INR')
                                ->to(auth()->user()->currency_code)
                                ->get(), 2);
                            $data[$key]['currency'] = auth()->user()->currency_symbol;;
                            $key++;
                        }
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                            ->from('INR')
                            ->to(auth()->user()->currency_code)
                            ->get(), 2);
                        $data[$key]['currency'] = auth()->user()->currency_symbol;;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                        ->from('INR')
                        ->to(auth()->user()->currency_code)
                        ->get(), 2);
                    $data[$key]['currency'] = auth()->user()->currency_symbol;;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function canceledAppoinments(Request $request)
    {
        try {
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', auth()->user()->id)->where('Appointment_Status', 'Cancel')->orderBy('Appointment_Date', 'DESC')->get();
            foreach ($array as $item) {
                // $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                // $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                // $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_id'] = $item->therapist->id;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] =  $item->end_time;
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                        $data[$key]['call_type_id'] = $item->callMethod->id;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['service'] = $item->service_id;
                        $data[$key]['follow_up_date'] = $item->follow_up_date;
                        $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                            ->from('INR')
                            ->to(auth()->user()->currency_code)
                            ->get(), 2);
                        $data[$key]['currency'] = auth()->user()->currency_symbol;;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_id'] = $item->therapist->id;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] =  $item->end_time;
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['Appointment_Status_color'] = statusColor($item->Appointment_Status);
                    $data[$key]['call_type_id'] = $item->callMethod->id;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['service'] = $item->service_id;
                    $data[$key]['follow_up_date'] = $item->follow_up_date;
                    $data[$key]['fee'] = round(CurrencyConverter::convert($item->fee)
                        ->from('INR')
                        ->to(auth()->user()->currency_code)
                        ->get(), 2);
                    $data[$key]['currency'] = auth()->user()->currency_symbol;
                    $key++;
                }
            }
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function addReview(Request $request)
    {
        try {
            if ($request->user_review_id) {
                $review = UserReview::where('id', $request->user_review_id)
                    ->update([
                        'rate' => $request->rate,
                        'comment' => $request->comment
                    ]);
            } else {
                $review = new UserReview();
                $review->therapist_id = $request->therapist_id;
                $review->user_id = auth()->user()->id;
                $review->appoinment_id = $request->appoinment_id;
                $review->rate = $request->rate;
                $review->comment = $request->comment;
                $review->save();
            }
            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Review added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
    public function getReview(Request $request)
    {
        try {

            $review = UserReview::where('appoinment_id', $request->appoinment_id)
                ->where('user_id', auth()->user()->id)
                ->first();

            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $review,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function reviewAppoinment(Request $request)
    {
        $review = UserReview::select(DB::raw('avg(rate) as review'))->where('user_id', auth()->user()->id)->get();

        $data['therapist'] = Therapist::select('id', 'full_name', 'designation', 'language_known', 'image')->where('id', $request->therapist_id)->first();
        $data['therapist']->image = asset('assets/uploads/therapist/') . '/' . $data['therapist']->image;
        $data['therapist']->total_sessions = count(Appointments::where('therapist_id', $request->therapist_id)->where('Appointment_Status', 'Completed')->get());
        $data['therapist']->review_average = number_format($review[0]->review, 1);
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function downloadPrescription(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->first();
        $pres = Prescription::where('appoinment_id', $request->appoinment_id)->first();
        if ($pres) {
            $file = asset('assets/uploads/prescription/' . $pres->attachment);
        } else {
            $file = NULL;
        }
        if ($pres) {

            return response()->json(
                array(
                    'status' => true,
                    'link' => $file,
                    'statuscode' => 200
                ),
                200
            );
        } else {

            return response()->json(
                array(
                    'status' => false,
                    'link' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
        // $headers = [
        //     'Content-Type' => 'application/pdf',
        // ];

        // return response()->download($file, 'eConsultation' . $data->user->First_Name . $data->user->Last_Name . ' _00' . $data->id . $data->user->id, $headers);
    }
    public function cancelReason(Request $request)
    {

        $data = Appointments::where('id', $request->appoinment_id)->pluck('cancel_reason')->first();

        if ($data) {

            return response()->json(
                array(
                    'status' => true,
                    'reason' => $data,
                    'statuscode' => 200
                ),
                200
            );
        } else {

            return response()->json(
                array(
                    'status' => false,
                    'reason' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function consulation(Request $request)
    {
        $data = ConsulationNote::where('appoinment_id', $request->appoinment_id)->pluck('note')->first();

        if ($data) {
            return response()->json(
                array(
                    'status' => true,
                    'consulation' => $data,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'consulation' => "",
                    'statuscode' => 301
                ),
                200
            );
        }
    }
    public function changeAppoinmentStatus(Request $request)
    {
        $data = [
            'appoinment_id' => $request->appoinment_id
        ];
        $notification = Admin::first();

        #store notification info into notifications table
        $notification->notify(new AppoinmentNotification($data));
        try {
            if ($request->status == 'Cancel') {
                $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date')->where('id', $request->appoinment_id)->first();
                $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
                $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
                $checkTime = Carbon::parse($appoinmentTime)->subHours(5);
                $currentDateTime = Carbon::now();

                if ($currentDateTime > $checkTime) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Cancel time exceed",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'cancel_reason' => $request->reason
                    ]);


                $point = WalletPoint::orderBy('id', 'DESC')->first();

                $amount = Appointments::where('id', $request->appoinment_id)->pluck('fee')->first();;
                $userpoint = $amount;



                $userwallet = UserWallet::where('user_id', auth()->user()->id)->first();
                if ($userwallet == null) {
                    $userBalance = 0;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = new UserWallet();
                    $userwalletadd->user_id = auth()->user()->id;
                    $userwalletadd->balance = $balance;
                    $userwalletadd->save();
                } else {
                    $userBalance = $userwallet->balance;
                    $balance = $userBalance + $userpoint;

                    $userwalletadd = UserWallet::where('id', $userwallet->id)->update([
                        'user_id' => auth()->user()->id,
                        'balance' => $balance
                    ]);
                }

                $userWalletTransaction = new UserWalletTransactions();
                $userWalletTransaction->user_id = auth()->user()->id;
                $userWalletTransaction->wallet_id = 2;
                $userWalletTransaction->type = 'Credit';
                $userWalletTransaction->amount = $amount;
                $userWalletTransaction->point = $userpoint;
                $userWalletTransaction->current_balance = $balance;
                $userWalletTransaction->save();

                if ($userWalletTransaction) {
                    return response()->json(
                        array(
                            'status' => true,
                            'data' => $request->status . " Your appoinment successfully. Refund amount updated to user wallet balance.",
                            'statuscode' => 200
                        ),
                        200
                    );
                } else {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Something went Wrong",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
            } elseif ($request->status == 'Resheduled') {
                $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date')->where('id', $request->appoinment_id)->first();
                $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
                $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
                $checkTime = Carbon::parse($appoinmentTime)->subHours(5);
                $currentDateTime = Carbon::now();

                if ($currentDateTime > $checkTime) {
                    return response()->json(
                        array(
                            'status' => false,
                            'data' => "Reshedule time exceed",
                            'statuscode' => 301
                        ),
                        200
                    );
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status,
                        'reshedule_reason' => $request->reason
                    ]);
            } else {
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $request->status
                    ]);
            }

            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $request->status . " Your appoinment successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function resheduleAppoinment(Request $request)
    {
        try {
            $appoinment = Appointments::select('Appointment_Time', 'Appointment_Date', 'therapist_id')->where('id', $request->appoinment_id)->first();
            $d = $appoinment->Appointment_Date . ' ' . $appoinment->Appointment_Time;
            $appoinmentTime = date("Y-m-d H:i:s", strtotime($d));
            $checkTime = Carbon::parse($appoinmentTime)->subHours(5);
            $currentDateTime = Carbon::now();

            if ($currentDateTime > $checkTime) {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Reshedule time exceed",
                        'statuscode' => 301
                    ),
                    200
                );
            }

            $duration = Slot::where('therapist_id', $appoinment->therapist_id)->pluck('call_duration')->first();
            $givenDateTime = date("H:i", strtotime($request->slot));

            $time = $request->booking_date . " " . $givenDateTime . ":00";
            $closeTime =  Carbon::parse($time)->addMinutes($duration);


            $appointment = Appointments::where('id', $request->appoinment_id)->update([
                'Appointment_Date' => date("Y-m-d", strtotime($request->booking_date)),
                'Appointment_Time' => $request->slot,
                'Appointment_Status' => 'Resheduled',
                'slot_id' => $request->slot_id,
                'end_time' => date('h:i A', strtotime($closeTime))
            ]);

            if ($appointment) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment resheduled Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }
}
